//==============================================================================
// Project:		Wealth transfers and their economic effects
// File name:	Individual wealth weights
// Objective: 	Apportion household wealth items to individuals
//
//==============================================================================

clear 

cd "XXXX"

use combined_filtered_restricted.dta, replace

drop if wave != 2 & wave != 6 & wave != 10 & wave != 14 & wave != 18 //drops waves that don't have a wealth module

*create flag for owning a share of the place of residence

gen own_home = 0 

foreach x of num 1/20{
    	
replace own_home = 1 if (hgxid`x' == xwaveid & hsoid`x' == 1) // sets flag equal to 1 if person owns a share of their home
	
}

drop if own_home == 0 // drop people who don't own a share of the place of residence

*age ranges for regression
local age_set 15 19 23 27 31 35 39 43 47 51 55 59 63 67 71 75 79 83 //ages in four year bins to ensure that people normally 'jump' one age bin each time the wealth module is conducted

local age //empty list to be defined below

foreach x of local age_set{
	gen age_`x' = 0
	replace age_`x' = 1 if hgage >= `x' & hgage < `x' + 4
	local age `age' age_`x' // builds the list
}

replace age_83 = 1 if hgage >= 83

gen age_0 = 0 
replace age_0 = 1 if hgage < 15

local age age_0 `age'

*gender for regression
gen male = 0
replace male = 1 if sex == 1
gen female = 0
replace female = 1 if male == 0

*home equity variable for regression
gen home_equity = hwhmvai - hwhmdti // contructed variable that's consistent with the wealth module

**create HH-level dataset

local gender male female
local all_list //empty list to populate later

foreach x of local age{
	
	foreach y of local gender{
			
			gen `x'_`y' = `x'*`y' // create variable of each combination of age and gender
			local all_list `all_list' `x'_`y' //build the list
			
	}
}

local HH_all_list //empty list to populate later

foreach x of local all_list{
	
	egen HH_`x' = total(`x'), by(hhrhid wave) //aggregate to the HH
	
	local HH_all_list `HH_all_list' HH_`x' //build the list
}

local HH_all_list_eq home_equity `HH_all_list' //new list including home equity

collapse (mean) `HH_all_list_eq', by(hhrhid wave) //collapse dataset to HH level

local wave 2 6 10 14 18 //waves the include the wealth module

foreach x of local wave{
	reg `HH_all_list_eq' if wave == `x', noconstant //run the model for each wave separately 

foreach y of local HH_all_list{
	gen b_`x'_`y' = _b[`y'] //use the coefficients from the regression as weights (to be normalised)
	replace b_`x'_`y' = 0 if b_`x'_`y' < 0 //replace negative weights with zero weights as recommended by the UN NTA manual - only a few instances of this
}

gen total_w_`x' = 0 //total weight for normalising, initially set to 0.

foreach y of local HH_all_list{
	replace total_w_`x' = total_w_`x' + `y'*b_`x'_`y' //take vector dot product of weighting vector and vector of number of people in HH in each group
}

gen total_adj_w_`x' = 0 //replace cases where the total weight = 0 by splitting wealth equally among all household members

foreach y of local HH_all_list{
	replace total_adj_w_`x' = total_adj_w_`x' + `y' //similar to above but no weights
}

foreach y of local HH_all_list{
	gen w_`x'_`y' = b_`x'_`y'/total_w_`x' // normalise weights to 1 for each HH
	replace w_`x'_`y' = `y'/total_adj_w_`x' if total_w_`x' == 0
}
}

foreach x of local HH_all_list{
	gen weight_`x' = 0
	
	foreach y of local wave{
		replace weight_`x' = w_`y'_`x' if wave == `y' //choose weighting scheme relevant to the year in which the HH was surveyed

	}
}

keep weight* wave hhrhid

save restricted_homeownership_weights.dta, replace
